def quicksort(items, left=None, right=None):
    # Wartości `left` i `right` reprezentują początek i koniec zakresu `items`:
    if left is None:
        left = 0 # Na początek `left` odwołuje się do pozycji 0
    if right is None:
        right = len(items) - 1 # Na początek `right` odwołuje się do pozycji ostatniego elementu tablicy

    print('\n..............quicksort() wywołana na przedziale:', items[left:right + 1])
    print('..................................Pełna lista to:', items)

    if right <= left:
        # Jeżeli lista ma zero lub jeden element, to jest już posortowana
        return  # PRZYPADEK BAZOWY

    # POCZĄTEK PARTYCJONOWANIA
    i = left # i przyjmuje wartość lewego końca przedziału
    pivotValue = items[right] # Jako wartość rozdzielającą wybieram ostatni element przedziału

    print('................Element rozdzielający (pivot) to:', pivotValue)

    # Przejście pętlą od lewego początku do wartości rozdzielającej (ale bez jej uwzględnienia):
    for j in range(left, right):
        # Jeżeli wartość pod danym indeksem jest mniejsza od wartości rozdzielającej, zamieniam je miejscami,
        # tak aby znajdowała się ona w lewej części listy `items`:
        if items[j] <= pivotValue:
            # Zamiana dwóch wartości miejscami:
            items[i], items[j] = items[j], items[i]
            i += 1

    # Umieszczam wartość rozdzielającą w lewej części listy `items`:
    items[i], items[right] = items[right], items[i]
    # KONIEC PARTYCJONOWANIA

    print('...........................Po zamianie zakres to:', items[left:right + 1])
    print('Rekurencyjnie wywołuję quicksort na przedziałach:', items[left:i], 'i', items[i + 1:right + 1])

    # Wywołanie quicksort() na obu partycjach:
    quicksort(items, left, i - 1) # PRZYPADEK REKURENCYJNY
    quicksort(items, i + 1, right) # PRZYPADEK REKURENCYJNY

myList = [0, 7, 6, 3, 1, 2, 5, 4]
quicksort(myList)
print('...............................Posortowana lista:', myList)
